# Contribution Guide

This page describes how to contribute changes to CSS Beautify.

Please do **not** create a pull request without reading this guide first. Failure to do so may result in the **rejection** of the pull request.

## CLA

Before we can accept any contributions, you need to sign [Contributor License Agreement](http://en.wikipedia.org/wiki/Contributor_License_Agreement). You can do that using Sencha Labs [online CLA](http://www.sencha.com/cla).

## Coding Policies

Make sure that your code passes [JSLint](http://jslint.com) checks.

Make sure your patch does break existing tests (open <code>test/index.html</code> in a web browser).

If you add a new feature, create a new test associated with that. Feature or enhancement pull request without a corresponding test will **not** be merged.

## Pull Request

For the actual contribution, please use [Github pull request](http://help.github.com/pull-requests/) workflow.

Please do not create a pull request for multiple unrelated commits. It is strongly recommended to create a topic branch and make the commits as atomic as possible for the merge. This makes it easy to review all the changes.

